@extends('layouts.master')

@section('title')
    لوحة التحكم
@endsection

@section('first-css')
@endsection

@section('content-body')
    <!--**********************************
                            Content body start
                        ***********************************-->
    @include('massages')
    @if (Auth::user()->role == 0)
        @include('admin.dashboard')
    @elseif(Auth::user()->role == 1)
        @include('trainer.dashboard')
    @else
        <!--**********************************
                            Content body end
                        ***********************************-->


        <div class="container">
            <div class="" style="min-height: 828px;">
                <div class="container-fluid">
                    <div class="row">
                        @isset($rooms)
                            @foreach ($rooms as $room)
                                <div class="col-xl-4 col-lg-4 col-md-6">
                                    <div class="card">
                                        <img class="card-img-top img-fluid"
                                            src="{{ asset('/images/card/' . mt_rand(1, 4) . '.jpg') }}" style="border-radius: 0"
                                            alt="Card image cap">
                                        <div class="mt-2">
                                            <h3 class="text-center text-primary fw-bold">
                                                برنامج @isset($room->room->course->title)
                                                    {{ $room->room->course->title }}
                                                @endisset
                                            </h3>
                                        </div>

                                        <div class="mt-1 py-2 pt-0 w-75 m-auto">
                                            <div class="d-flex align-items-center justify-content-start text-center">
                                                <i class="fa fa-briefcase ms-3 text-warning"></i>
                                                <h6 class="text-center text-secondary">
                                                    برنامج @isset($room->room->course->title)
                                                        {{ $room->room->course->title }}
                                                    @endisset
                                                </h6>
                                            </div>
                                            <div class="d-flex align-items-center justify-content-start">
                                                <i class="mdi mdi-account-group  ms-3 text-warning"></i>
                                                <div> مشرف البرنامج: @isset($room->room->trainer->name)
                                                        {{ $room->room->trainer->name }}
                                                    @endisset
                                                </div>
                                            </div>
                                            <div class="d-flex align-items-center justify-content-start">
                                                <i class=" bi bi-pencil-square  ms-3 text-warning"></i>
                                                <div> عدد الدروس
                                                    @isset($room->room->course->lessons)
                                                        {{ count($room->room->course->lessons) }}
                                                    @endisset
                                                </div>
                                            </div>
                                        </div>
                                        <div class="post-more my-3 text-center">
                                            <a
                                                class="btn btn-primary mb-2  w-75 "href="{{ route('appendix_listRoom', $room->id) }}">
                                                الملحقات
                                            </a>
                                            @php
                                                $hase_certificate = false;
                                            @endphp
                                            @isset($certificates)
                                                @foreach ($certificates as $certificate)
                                                    @if ($certificate->room_id == $room->room->id)
                                                        <a
                                                            class="btn btn-primary  w-75 "href="{{ route('get_certificate', $certificate->id) }}">
                                                            الشهادة
                                                        </a>
                                                        @php
                                                            $hase_certificate = true;
                                                        @endphp
                                                        @break
                                                    @else
                                                        @php
                                                            $hase_certificate = false;
                                                        @endphp
                                                    @endif
                                                @endforeach
                                            @if (!$hase_certificate)
                                                <a
                                                    class="btn btn-primary  w-75 "href="{{ route('students_exam_list', $room->room->id) }}">
                                                    الاختبارات
                                                </a>
                                            @endif
                                        @else
                                            <a
                                                class="btn btn-primary  w-75 "href="{{ route('students_exam_list', $room->room->id) }}">
                                                الاختبارات
                                            </a>
                                        @endisset

                                    </div>
                                </div>
                            </div>
                        @endforeach
                    @endisset
                </div>
            </div>
        </div>

    </div>
@endif
@endsection

@section('script')
<script>
    $(document).ready(function() {
        $('table.display').DataTable();
    });
</script>
<script src="{{ asset('/vendor/datatables/js/jquery.dataTables.min.js') }}"></script>
<script src="{{ asset('/js/plugins-init/datatables.init.js') }}"></script>
@endsection
